/**
 * Config Loader - Versão simplificada (sem fetch)
 * 
 * Espera que config/config.js seja carregado antes deste script
 */
(function () {
  'use strict';

  const DEFAULT_CONFIG = {
    telegram: { bot: null, mode: null, miniapp_path: null },
    redirect: { enabled: true, delay_ms_min: null, delay_ms_max: null, id_query_key: null, allow_query_override: true, hold_param: 'hold' },
    links: {
      channel_fallback: null,
      broker_default: null,
      plataform_default: null
    },
    storage: { custom_link_key: null, prefix: null }
  };

  // Config já está em window.__TRC_CONFIG__ se config.js foi carregado
  function getConfig() {
    if (typeof window.__TRC_CONFIG__ === 'object' && window.__TRC_CONFIG__) {
      return window.__TRC_CONFIG__;
    }
    return DEFAULT_CONFIG;
  }

  // Config já está pronto (síncrono)
  window.__TRC_CONFIG__ = window.__TRC_CONFIG__ || DEFAULT_CONFIG;
  window.__trc_config_ready = Promise.resolve(window.__TRC_CONFIG__);
  window.__getTrcConfig = getConfig;
})();
